//Aim:To design composite low-pass filter.
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
R0=75;//R0 is the nominal impedence(in ohms).
fc=2*(10^6);//fc is the cut-off frequency in Hz.
f_infinity=2.05*(10^6);//f_infinity represents that the infinite attenuation.
//pole is placed at 2.05 MHz.

//Constant k section :
L=R0/(%pi*fc);
disp('H',L,'L=')
C=1/(%pi*R0*fc);
disp('F',C,'C=')

//m-derived section :
m=sqrt(1-((fc/f_infinity)^2));
disp(m,'m=')
a=(m*L)/2;
disp('H',a,'For m-derived section, mL/2=')
b=m*C;
disp('F',b,'For m-derived section, mC=')
c=((1-(m^2))/(4*m))*L;
disp('H',c,'For m-derived section, ((1-(m^2))/(4*m)))*L=')

//Matching sections: with m=0.6
//Let us call this new 'm' as 'm1'.
m1=0.6;
d=(m1*L)/2;
disp('H',d,'For matching section, m1L/2=')
e=(m1*C)/2;
disp('F',e,'For matching section, m1C/2=')
f=((1-(m1^2))/(2*m1))*L;
disp('H',f,'For matching section, ((1-(m1^2))/(2*m1)))*L=')

